﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Reflection;
using System.Diagnostics;

namespace Dizplay_Cruise
{
    static class Program
    {
        static readonly string LogPath = Path.Combine(Application.StartupPath, "Log.txt");

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            AppDomain.CurrentDomain.UnhandledException += 
                new UnhandledExceptionEventHandler(CurrentDomain_UnhandledException);
            Application.ThreadException +=
                new ThreadExceptionEventHandler(Application_ThreadException);

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Dizplay());
        }

        static void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
        {
            ManageUnhandledException(e.Exception);
        }

        static void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            ManageUnhandledException((Exception)e.ExceptionObject);
        }

        static void ManageUnhandledException(Exception E)
        {
            Processor.SendCrashMail(E);
            return;
            try
            {
                Dizplay.iSend("^1Dizplay crash-protection activated.", true);

                using (StreamWriter writer = new StreamWriter(LogPath))
                {
                    writer.WriteLine("Name: " + Assembly.GetExecutingAssembly().GetName().Name);
                    writer.WriteLine("Version: " + Assembly.GetExecutingAssembly().GetName().Version.ToString());
                    writer.WriteLine("Date: " + DateTime.Now.ToString());
                    writer.WriteLine("OS: " + Environment.OSVersion.VersionString);
                    writer.WriteLine("Culture: " + Thread.CurrentThread.CurrentUICulture);
                    writer.WriteLine("Message: " + E.Message);
                    writer.WriteLine("Source: " + E.Source);
                    writer.WriteLine("Target: " + E.TargetSite);
                    writer.WriteLine("Stack Trace: " + E.StackTrace);
                    writer.WriteLine("Inner Exception: " + E.InnerException);
                }

                Dizplay.iSend("^7Restarting the application...", true);
                Process.Start(Process.GetCurrentProcess().MainModule.FileName);

                Dizplay.iSend("^7Trying to send crash data via email...", true);
                Processor.SendCrashMail(E);
            }
            catch
            {
                Dizplay.iSend("/msg ^1Dizplay emergency log failed.", true);
            }
            finally
            {
                Dizplay.iSend("^1Self-terminating to avoid crashing...", true);
                Process.GetCurrentProcess().Kill();
            }
        }
    }
}
